//+------------------------------------------------------------------+
//|                                                     Receiver.mqh |
//|                                 Copyright 2022-2024, Yuriy Bykov |
//|                            https://www.mql5.com/ru/users/antekov |
//+------------------------------------------------------------------+
#property copyright "Copyright 2022-2024, Yuriy Bykov"
#property link      "https://www.mql5.com/ru/users/antekov"
#property version   "1.04"

//+------------------------------------------------------------------+
//| Базовый класс перевода открытых объемов в рыночные позиции       |
//+------------------------------------------------------------------+
class CReceiver {
protected:
   static ulong      s_magic;       // Magic
   bool m_isChanged;                // Есть ли изменения в составе виртуальных позиций

public:
   CReceiver();
   virtual bool      Correct() = 0; // Корректировка открытых объёмов
   virtual void      Changed();     // Установка наличия изменений извне
};

ulong CReceiver::s_magic = 0;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CReceiver::CReceiver() : m_isChanged(true) {}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CReceiver::Changed() {
   m_isChanged = true;
}
//+------------------------------------------------------------------+
